/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCFErrorIds;
import com.ibm.hwmca.base.updates.MCFFileParser;
import com.ibm.hwmca.base.updates.MCFFilter;
import com.ibm.hwmca.base.updates.MCFLine;
import com.ibm.hwmca.base.updates.MCL;
import com.ibm.hwmca.base.updates.NewMCFFilter;
import com.ibm.hwmca.base.updates.PatchFile;
import com.ibm.hwmca.base.updates.PatchedFileList;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.IssueCmd;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Update;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MCF
extends Update
implements MCFErrorIds {
    private static final String TRACE_MASKT = "XMCFMCFT";
    private static final String TRACE_MASKF = "XMCFMCFF";
    private static final String TRACE_MASKD = "XMCFMCFD";
    protected static final String STAGING_AREA_FILE = "iqzmcf.mcf";
    protected static final String TEMP_STAGING_AREA_FILE = "iqzmcf.tcf";
    protected static final String PATCHED_STAGING_AREA_FILE = "iqzmcf.hcf";
    protected static final String AFTER_REBOOT_FILES = "iqzmlock.sh";
    protected static final String AT_SHUTDOWN_SCRIPT = "/console/native/runAsRoot/iqzmlock.pl";
    protected static final String XMCF_ACCEPT_LIST = "iqzmacpt.lst";
    protected static final String ACCEPT_HISTORY = "ac.dat";
    private static final int XMCF_MAX_LINES = 99;
    private static final String XMCF_TEMP_FILE = "/tmp/mcf.tmp";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char FILE_SEP = File.separatorChar;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCF");
    private char controlFilePrefix;
    private String controlFileName;
    private int typeOfMCF;
    static final int TEMPORARY_MCF = 1;
    static final int PERMANENT_MCF = 2;
    static final int AS_REQUIRED_MCF = 3;
    private int state;
    protected boolean isError;
    private boolean automaticallyUpdated;
    private boolean parsed;
    private boolean syntaxError;
    private int syntaxErrorLine;
    private String streamName;
    private String id;
    private LocalizableText description;
    private Date creationDate;
    protected Date lastStatusChangeDate;
    private MCL collection;
    private String stagingAreaPath;
    private String patchedStagingAreaPath;
    private String tempStagingAreaPath;
    private String author;
    private MCFLine[] linesOfMCF;
    private List fileNamesOfMCF;
    private List modulesOfMCF;
    private LocalizableText displayableError;
    private String bundleName;
    private String processingFile;
    private boolean newFormat;
    private String afterRebootShellFilePath;
    private MCFLine[] parsedMCFLines;
    private MCFLine currModMcfLine = null;
    private int index;
    private boolean componentFound;
    private boolean lastQueuedExists;
    private boolean passedApplyTest = false;

    public MCF(ECStream ecData, String controlFileName) throws HException {
        super(ecData);
        Trace.trace(TRACE_MASKT, "-> MCF()");
        this.typeOfMCF = MCF.determineMCFType(controlFileName);
        this.controlFileName = controlFileName;
        int dotPosition = controlFileName.indexOf(".");
        String fileExtension = controlFileName.substring(dotPosition + 1);
        if (fileExtension.equals("xml")) {
            this.id = controlFileName.substring(dotPosition - 3, dotPosition);
            this.newFormat = true;
        } else {
            this.id = fileExtension;
            this.newFormat = false;
        }
        this.streamName = super.getUpdateableComponent().getECNumber();
        Trace.trace(TRACE_MASKD, "this.id=[" + this.id + "].");
        this.controlFilePrefix = controlFileName.charAt(0);
        this.collection = null;
        this.initMCF();
        Trace.trace(TRACE_MASKT, "<- MCF()");
    }

    public MCF(ECStream ecData, MCL mcl, String controlFileName) throws HException {
        super(ecData);
        Trace.trace(TRACE_MASKT, "-> MCF()");
        int dotPosition = controlFileName.indexOf(".");
        String fileExtension = controlFileName.substring(dotPosition + 1);
        if (fileExtension.equals("xml")) {
            this.id = controlFileName.substring(dotPosition - 3, dotPosition);
            this.newFormat = true;
        } else {
            this.id = fileExtension;
            this.newFormat = false;
        }
        this.streamName = super.getUpdateableComponent().getECNumber();
        Trace.trace(TRACE_MASKD, "this.id=[" + this.id + "].");
        this.controlFilePrefix = controlFileName.charAt(0);
        this.typeOfMCF = MCF.determineMCFType(controlFileName);
        this.controlFileName = controlFileName;
        this.collection = mcl;
        this.initMCF();
        Trace.trace(TRACE_MASKT, "<- MCF()");
    }

    public MCF(ECStream ecData, String mcl, String id, String description, Date acceptDate) throws HException {
        super(ecData);
        this.description = new LocalizableText(description);
        this.id = id;
        this.lastStatusChangeDate = (Date)acceptDate.clone();
        this.collection = new MCL(ecData, Integer.parseInt(mcl, 10), true);
        this.bundleName = "com/ibm/hwmca/base/res/message";
        Trace.trace(TRACE_MASKT, "<> MCF()");
    }

    private void initMCF() throws HException {
        Trace.trace(TRACE_MASKT, "-> initMCF()");
        this.state = 1;
        this.isError = false;
        this.parsed = false;
        this.stagingAreaPath = BaseFileControl.getFilePath(STAGING_AREA_FILE);
        this.tempStagingAreaPath = BaseFileControl.getFilePath(TEMP_STAGING_AREA_FILE);
        this.patchedStagingAreaPath = BaseFileControl.getFilePath(PATCHED_STAGING_AREA_FILE);
        this.afterRebootShellFilePath = BaseFileControl.getFilePath(AFTER_REBOOT_FILES) + AFTER_REBOOT_FILES;
        this.displayableError = new LocalizableText("No error");
        this.bundleName = "com/ibm/hwmca/base/res/message";
        if (this.newFormat) {
            this.parseNewKeywords();
        } else {
            this.parseKeywords();
        }
        File afterRebootFile = new File(this.afterRebootShellFilePath);
        Trace.trace(TRACE_MASKD, "Checking for existence of " + afterRebootFile);
        if (!afterRebootFile.exists()) {
            Trace.trace(TRACE_MASKD, "Nothing pending state=" + this.state);
            if (this.state == 2) {
                this.state = 4;
                this.updateControlFile();
            }
            if (this.state == 3) {
                this.state = 1;
                this.updateControlFile();
            }
        }
        Trace.trace(TRACE_MASKD, "<> getModuleNames has " + this.modulesOfMCF.size() + " modules.");
        Trace.trace(TRACE_MASKT, "<- initMCF()");
    }

    public String getAuthor() {
        return this.author;
    }

    public UpdateCollection getCollection() {
        return this.collection;
    }

    public String getControlFileName() {
        return this.controlFileName;
    }

    public char getControlFilePrefix() {
        return this.controlFilePrefix;
    }

    public Date getCreationDate() {
        Date out = this.creationDate;
        if (out != null) {
            out = (Date)this.creationDate.clone();
        }
        return out;
    }

    public LocalizableText getDescription() {
        return this.description;
    }

    public LocalizableText getDisplayableError() {
        return this.displayableError;
    }

    public String getDisplayableName() {
        return this.streamName + "." + this.id;
    }

    public LocalizableText getDisplayableState() {
        LocalizableText displayableState;
        if (this.isError) {
            displayableState = new LocalizableText("Error");
        } else {
            Trace.trace(TRACE_MASKD, "this.state=" + this.state + ".");
            switch (this.state) {
                case 1: {
                    displayableState = new LocalizableText("Deactivated");
                    break;
                }
                case 2: {
                    displayableState = new LocalizableText("Activated pending reboot");
                    break;
                }
                case 3: {
                    displayableState = new LocalizableText("Deactivated pending reboot");
                    break;
                }
                case 4: {
                    if (this.automaticallyUpdated) {
                        displayableState = new LocalizableText("AutoActivated");
                        break;
                    }
                    displayableState = new LocalizableText("Activated");
                    break;
                }
                default: {
                    displayableState = new LocalizableText("StateError");
                    Trace.trace(TRACE_MASKF, "Unrecognized state " + this.state + ".");
                }
            }
        }
        return displayableState;
    }

    public List getFileNames() {
        Trace.trace(TRACE_MASKD, "<> getFileNames returns " + this.fileNamesOfMCF.size() + " files.");
        return this.fileNamesOfMCF;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastStatusChangeDate() {
        Date out = this.lastStatusChangeDate;
        if (out != null) {
            out = (Date)this.lastStatusChangeDate.clone();
            Trace.trace(TRACE_MASKD, "<> MCF.getLastStatusChangeDate() - returns [" + out + "].");
        }
        return out;
    }

    public List getModuleNames() {
        Trace.trace(TRACE_MASKD, "<> getModuleNames returns " + this.modulesOfMCF.size() + " modules.");
        return this.modulesOfMCF;
    }

    public int getState() {
        return this.state;
    }

    public String getStagingAreaPath() {
        return this.stagingAreaPath;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isConfigurationSpecific() {
        boolean configurationSpecific = 3 == this.typeOfMCF;
        return configurationSpecific;
    }

    public boolean isSyntaxError() {
        return this.syntaxError;
    }

    public int getSyntaxErrorLine() {
        return this.syntaxErrorLine;
    }

    public int getTypeOfMCF() {
        return this.typeOfMCF;
    }

    public void apply() throws HException, IllegalStateException {
        this.apply(false);
    }

    public void apply(boolean processingMCL) throws HException, IllegalStateException {
        Trace.trace(TRACE_MASKT, "-> apply(" + processingMCL + ")");
        if (this.state == 1 || this.state == 3) {
            this.displayableError = null;
            if (!this.parsed) {
                this.parseKeywords();
            }
            this.isError = false;
            this.processKeywords(true, processingMCL, this.linesOfMCF.length);
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + " has been activated.");
        } else if (this.state == 4 || this.state == 2) {
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + " is already activated. Nothing to do.");
        } else {
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + "cannot be activated because it is in state " + this.state + ".");
            this.displayableError = new LocalizableText("MCF " + this.controlFileName + " cannot be activated because it is " + this.getDisplayableState() + ".");
            throw new IllegalStateException("MCF is not in proper state for activation");
        }
        Trace.trace(TRACE_MASKT, "<- apply()");
    }

    public void delete() throws IllegalStateException {
        this.delete(false);
    }

    public void delete(boolean processingMCL) throws IllegalStateException {
        Trace.trace(TRACE_MASKT, "-> MCF.delete(" + processingMCL + ")");
        this.displayableError = null;
        if (this.state != 1) {
            Trace.trace(TRACE_MASKF, "   MCF.delete() - MCF " + this.controlFileName + " cannot be deleted because it is in state " + this.state + ".");
            this.setLastMessage("MCFNOTDACT");
            this.displayableError = new LocalizableText("MCF " + this.controlFileName + " cannot be deleted because it is " + this.getDisplayableState() + ".");
            throw new IllegalStateException("MCF is not in proper state for delete.");
        }
        boolean canWeDeleteIt = false;
        if (1 == this.typeOfMCF) {
            canWeDeleteIt = true;
        } else if (null != this.collection && processingMCL) {
            canWeDeleteIt = true;
        } else if (null == this.collection && !processingMCL && !this.passedApplyTest) {
            canWeDeleteIt = true;
        }
        Trace.trace(TRACE_MASKF, "   MCF.delete() - Collection: " + this.collection + " - passedApplyTest is " + this.passedApplyTest + " - MCF type is " + this.typeOfMCF + " (1 is Temporary, 2 is Permanent, 3 is As Required)");
        if (!canWeDeleteIt) {
            String errorString = "MCF " + this.controlFileName + " cannot be deleted because it is" + " associated with an MCL. It must be" + " deleted as a part of that MCL using" + " Change Internal Code.";
            Trace.trace(TRACE_MASKF, errorString);
            this.setLastMessage("MCFPERM");
            this.displayableError = new LocalizableText(errorString);
            throw new IllegalStateException(errorString);
        }
        String[] files = this.getListOfFiles();
        for (int i = 0; i < files.length; ++i) {
            File fileToDelete = new File(files[i]);
            if (fileToDelete.isDirectory()) {
                Trace.trace(TRACE_MASKF, "The directory tree" + fileToDelete.getPath() + " is being deleted.");
                IssueCmd cmd = new IssueCmd();
                int rc = cmd.execute("rm -r " + fileToDelete.getPath());
                if (0 == rc) continue;
                Trace.trace(TRACE_MASKF, "Error " + rc + " deleting the " + fileToDelete.getPath() + " directory tree.");
                Trace.trace(TRACE_MASKF, "Error messages were: \n" + cmd.getErrorOutput());
                continue;
            }
            Trace.trace(TRACE_MASKF, "The file " + fileToDelete.getPath() + " is being deleted.");
            fileToDelete.delete();
        }
        Trace.trace(TRACE_MASKT, "<- delete()");
    }

    public void commit() throws IllegalStateException, HException {
        Trace.trace(TRACE_MASKT, "-> commit()");
        if (this.state == 4) {
            String[] files = this.getListOfFiles();
            for (int i = 0; i < files.length; ++i) {
                File fileToCommit = new File(files[i]);
                if (fileToCommit.isDirectory()) {
                    Trace.trace(TRACE_MASKF, "The directory tree" + fileToCommit.getPath() + " is being committed.");
                    IssueCmd cmd = new IssueCmd();
                    int rc = cmd.execute("rm -r " + fileToCommit.getPath());
                    if (0 == rc) continue;
                    Trace.trace(TRACE_MASKF, "Error " + rc + " deleting the " + fileToCommit.getPath() + " directory tree.");
                    Trace.trace(TRACE_MASKF, "Error messages were: \n" + cmd.getErrorOutput());
                    continue;
                }
                Trace.trace(TRACE_MASKF, "The file " + fileToCommit.getPath() + " is being committed.");
                fileToCommit.delete();
            }
            String acceptHistoryFile = this.streamName + ACCEPT_HISTORY;
            String acceptHistoryPath = null;
            try {
                acceptHistoryPath = BaseFileControl.getFilePath(acceptHistoryFile);
                acceptHistoryFile = acceptHistoryPath + acceptHistoryFile;
                try {
                    Trace.trace(TRACE_MASKD, "Writing to [" + acceptHistoryFile + "].");
                    FileWriter outputStream = new FileWriter(acceptHistoryFile, true);
                    UserContext userContext = UserContext.getCurrentUserContext();
                    DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
                    formatter.setTimeZone(userContext.getTimeZone());
                    String fileCommand = this.collection.getId() + "~" + this.id + "~" + this.description + "~" + formatter.format(new Date()) + LINE_SEPARATOR;
                    outputStream.write(fileCommand);
                    outputStream.close();
                }
                catch (IOException e) {
                    this.logAndRethrowError("Error writing accept history file " + acceptHistoryFile + "." + e, (short)-8162, e);
                }
            }
            catch (HException hexc) {
                this.logAndRethrowError("Error getting path of accept history file " + acceptHistoryFile, (short)-8158, hexc);
            }
        } else {
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + "cannot be committed because it is in state " + this.state + ".");
            this.displayableError = new LocalizableText("MCF " + this.controlFileName + " cannot be committed because it is " + this.getDisplayableState() + ".");
            throw new IllegalStateException("MCF is not in proper state for commit");
        }
        Trace.trace(TRACE_MASKT, "<- commit()");
    }

    public void reject() throws HException, IllegalStateException {
        this.reject(false);
    }

    public void reject(boolean processingMCL) throws HException, IllegalStateException {
        Trace.trace(TRACE_MASKT, "-> reject(" + (processingMCL ? "true" : "false") + ")");
        if (this.state == 4 || this.state == 2) {
            this.displayableError = null;
            if (!this.parsed) {
                this.parseKeywords();
            }
            this.isError = false;
            this.processKeywords(false, processingMCL, this.linesOfMCF.length);
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + " has been deactivated.");
        } else if (this.state == 1 || this.state == 3) {
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + " is already deactivated.");
        } else {
            Trace.trace(TRACE_MASKF, "MCF " + this.controlFileName + " cannot be deactivated because it is in state " + this.state + ".");
            this.displayableError = new LocalizableText("MCF " + this.controlFileName + " cannot be deactivated because it is " + this.getDisplayableState() + ".");
            throw new IllegalStateException("MCF is not in proper state for deactivation");
        }
        Trace.trace(TRACE_MASKT, "<- reject()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void parseKeywords() throws HException {
        block25: {
            subcommand = " ";
            subcommand2 = " ";
            Trace.trace("XMCFMCFT", "-> parseKeywords()");
            arrayIndex = 0;
            fileCount = 0;
            fileSuffix = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            instream = null;
            try {
                Trace.trace("XMCFMCFD", "stagingAreaPath=[" + this.stagingAreaPath + "].");
                Trace.trace("XMCFMCFD", "controlFileName=[" + this.controlFileName + "].");
                controlFile = this.stagingAreaPath + this.controlFileName;
                instream = new BufferedReader(new FileReader(controlFile));
                this.processingFile = controlFile;
                Trace.trace("XMCFMCFF", "File " + controlFile + " is being opened for parsing.");
                fileStats = new File(controlFile);
                lastModifiedDate = fileStats.lastModified();
                this.lastStatusChangeDate = new Date(lastModifiedDate);
                this.newFormat = false;
                bytesToSkip = 14L;
                for (bytesSkipped = 0L; bytesSkipped < 14L; bytesSkipped += instream.skip(bytesToSkip - bytesSkipped)) {
                    Trace.trace("XMCFMCFD", "Total bytes skipped=" + bytesSkipped);
                }
                statusBits = instream.read();
                Trace.trace("XMCFMCFD", "statusBits=" + statusBits);
                this.automaticallyUpdated = 1 == (statusBits & 1);
                this.isError = 64 == (statusBits & 64);
                if (2 == (statusBits & 2)) {
                    this.state = 16 == (statusBits & 16) ? 2 : 4;
                }
                if (32 == (statusBits & 32)) {
                    this.state = 16 == (statusBits & 16) ? 3 : 1;
                }
                bytesSkipped = instream.skip(1L);
                authorLine = new char[10];
                bytesRead = instream.read(authorLine, 0, 10);
                this.author = new String(authorLine);
                Trace.trace("XMCFMCFD", "author=[" + this.author + "].");
                bytesSkipped = instream.skip(27L);
                descriptionOfMCF = new char[36];
                bytesRead = instream.read(descriptionOfMCF, 0, 36);
                this.description = new LocalizableText(new String(descriptionOfMCF));
                Trace.trace("XMCFMCFD", "description=[" + this.description + "].");
                bytesSkipped = instream.skip(9L);
                lineNumber = 1;
                this.syntaxError = false;
                componentFound = false;
                parsedMCFlines = new MCFLine[1000];
                this.fileNamesOfMCF = new ArrayList<E>();
                this.modulesOfMCF = new ArrayList<E>();
                controlFileLine = new char[33];
                while (33 == instream.read(controlFileLine, 0, 33)) {
                    controlFileString = new String(controlFileLine);
                    tokens = new StringTokenizer(controlFileString, " =");
                    commentLine = false;
                    command = tokens.nextToken();
                    if (command.equals("*")) {
                        commentLine = true;
                        if (tokens.hasMoreTokens()) {
                            command = tokens.nextToken();
                        }
                    }
                    if (tokens.hasMoreTokens()) {
                        subcommand = tokens.nextToken();
                        if (tokens.hasMoreTokens()) {
                            subcommand2 = tokens.nextToken();
                        }
                    }
                    Trace.trace("XMCFMCFD", "command=[" + command + "].");
                    Trace.trace("XMCFMCFD", "subcommand=[" + subcommand + "].");
                    if (command.equals("EFILE")) {
                        subcommand2 = "(" + fileSuffix.charAt(fileCount) + ")";
                    }
                    Trace.trace("XMCFMCFD", "subcommand2=[" + subcommand2 + "].");
                    parsedMCFlines[arrayIndex] = new MCFLine(command, subcommand, subcommand2);
                    parsedCommand = parsedMCFlines[arrayIndex].getCommand();
                    Trace.trace("XMCFMCFD", "parsedCommand=" + parsedCommand + ".");
                    if (parsedCommand == 255 && !commentLine) {
                        this.syntaxError = true;
                        this.isError = true;
                        this.syntaxErrorLine = lineNumber;
                        this.isError = true;
                        this.logError("Syntax error on line " + lineNumber + " of MCF " + this.controlFileName, (short)-8163);
                    }
                    if (parsedCommand == 1 || parsedCommand == 3 || parsedCommand == 2 || parsedCommand == 12) {
                        filename = this.controlFilePrefix + this.streamName + subcommand2 + "." + this.getId();
                        this.fileNamesOfMCF.add(filename);
                        this.modulesOfMCF.add(subcommand);
                        ++fileCount;
                        Trace.trace("XMCFMCFD", "<> getModuleNames has " + this.modulesOfMCF.size() + " modules.");
                    }
                    if (parsedCommand != 0) {
                        arrayIndex = (short)(arrayIndex + 1);
                        if (parsedCommand == 13) {
                            componentFound = true;
                        }
                    }
                    ++lineNumber;
                }
                if (!componentFound) {
                    this.syntaxError = true;
                    this.isError = true;
                    this.syntaxErrorLine = lineNumber;
                    this.logError("No component keyword found in MCF " + this.controlFileName, (short)-8192);
                }
                this.linesOfMCF = new MCFLine[arrayIndex];
                System.arraycopy(parsedMCFlines, 0, this.linesOfMCF, 0, arrayIndex);
                this.parsed = true;
                var31_27 = null;
                ** if (null == instream) goto lbl-1000
            }
            catch (Throwable var30_33) {
                var31_29 = null;
                if (null != instream) {
                    try {
                        instream.close();
                    }
                    catch (IOException e) {
                        this.isError = true;
                        this.logError("Error on close of control file =" + e, (short)-8188);
                    }
                }
                throw var30_33;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    this.isError = true;
                    this.logError("Error on close of control file =" + e, (short)-8188);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (IOException e) {
                    this.isError = true;
                    this.logError("IO error =" + e, (short)-8190);
                    var31_28 = null;
                    if (null != instream) {
                        try {
                            instream.close();
                        }
                        catch (IOException e) {
                            this.isError = true;
                            this.logError("Error on close of control file =" + e, (short)-8188);
                        }
                    }
                }
            }
        }
        Trace.trace("XMCFMCFT", "<- parseKeywords()");
    }

    private void parseNewKeywords() throws HException {
        Trace.trace(TRACE_MASKT, "-> parseNewKeywords()");
        this.fileNamesOfMCF = new ArrayList();
        this.modulesOfMCF = new ArrayList();
        try {
            String controlFile;
            Trace.trace(TRACE_MASKD, "stagingAreaPath=[" + this.stagingAreaPath + "].");
            Trace.trace(TRACE_MASKD, "controlFileName=[" + this.controlFileName + "].");
            this.processingFile = controlFile = this.stagingAreaPath + this.controlFileName;
            Trace.trace(TRACE_MASKF, "File " + controlFile + " is being opened for parsing.");
            File fileStats = new File(controlFile);
            long lastModifiedDate = fileStats.lastModified();
            this.lastStatusChangeDate = new Date(lastModifiedDate);
            Trace.trace(TRACE_MASKD, "this.lastStatusChangeDate=[" + this.lastStatusChangeDate + "].");
            MCFFileParser parser = new MCFFileParser(controlFile);
            Document document = parser.getDocument();
            this.parsedMCFLines = new MCFLine[1000];
            this.index = 0;
            this.componentFound = false;
            this.traverse(document);
            this.linesOfMCF = new MCFLine[this.index];
            if (!this.componentFound) {
                this.syntaxError = true;
                this.isError = true;
                this.logError("No component keyword found in MCF " + this.controlFileName, (short)-8192);
            }
            System.arraycopy(this.parsedMCFLines, 0, this.linesOfMCF, 0, this.index);
            this.parsed = true;
        }
        catch (HException e) {
            this.isError = true;
            this.logError("Error =" + e, (short)-8190);
            throw e;
        }
        Trace.trace(TRACE_MASKT, "<- parseNewKeywords()");
    }

    private void traverse(Node node) throws HException {
        Trace.trace(TRACE_MASKT, "-> MCF.traverse()");
        try {
            short nodeType = node.getNodeType();
            String text = "";
            if (nodeType == 9) {
                Trace.trace(TRACE_MASKF, "   MCF.traverse() - traversing Document node");
                Document doc = (Document)node;
                this.traverse(doc.getDocumentElement());
            } else if (nodeType == 1) {
                String nodeName = node.getNodeName();
                Trace.trace(TRACE_MASKF, "   MCF.traverse() - name of node=[" + nodeName + "].");
                if (nodeName.equals("mcffile") || nodeName.equals("modules") || nodeName.equals("keywords")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.traverse(children.item(i));
                    }
                } else if (nodeName.equals("module")) {
                    MCFLine moduleMcfLine;
                    String name = "";
                    String filename = "";
                    String command = "";
                    String moduleName = "";
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node current = attributes.item(i);
                        name = current.getNodeName();
                        if (name.equals("name")) {
                            moduleName = current.getNodeValue();
                            continue;
                        }
                        if (!name.equals("type")) continue;
                        command = current.getNodeValue();
                    }
                    filename = this.controlFilePrefix + this.streamName + this.getId() + '_' + moduleName;
                    this.parsedMCFLines[this.index] = moduleMcfLine = new MCFLine(command, moduleName);
                    int cmd = moduleMcfLine.getCommand();
                    if (255 == cmd) {
                        this.syntaxError = true;
                        this.isError = true;
                        this.logError("Invalid module type = [" + command + "]", (short)-8154);
                    }
                    ++this.index;
                    this.fileNamesOfMCF.add(filename);
                    this.modulesOfMCF.add(moduleName);
                    Trace.trace(TRACE_MASKF, "command = [" + command + "], module = [" + moduleName + "], filename = [" + filename + "].");
                    Trace.trace(TRACE_MASKD, "<> getModuleNames has " + this.modulesOfMCF.size() + " modules.");
                    this.currModMcfLine = moduleMcfLine;
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.traverse(children.item(i));
                    }
                    Trace.trace(TRACE_MASKF, "   MCF.traverse() - module MCFLine value is [" + moduleMcfLine + "].");
                } else if (nodeName.equals("permissions")) {
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node current = attributes.item(i);
                        String name = current.getNodeName();
                        if (name.equals("owner")) {
                            this.currModMcfLine.setOwner(current.getNodeValue());
                            continue;
                        }
                        if (name.equals("group")) {
                            this.currModMcfLine.setGroup(current.getNodeValue());
                            continue;
                        }
                        if (!name.equals("permission-bits")) continue;
                        this.currModMcfLine.setPermissions(current.getNodeValue());
                    }
                } else if (nodeName.equals("link")) {
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node current = attributes.item(i);
                        String name = current.getNodeName();
                        if (name.equals("link-target")) {
                            this.currModMcfLine.setLinkTargetFileName(current.getNodeValue());
                            continue;
                        }
                        if (!name.equals("link-type")) continue;
                        this.currModMcfLine.setLinkType(current.getNodeValue());
                    }
                } else if (nodeName.equals("component")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    this.parsedMCFLines[this.index] = new MCFLine(nodeName, text);
                    if (this.parsedMCFLines[this.index].getCommand() == 13) {
                        this.componentFound = true;
                    }
                    ++this.index;
                    Trace.trace(TRACE_MASKD, "component=[" + text + "].");
                } else if (nodeName.equals("keyword")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    StringTokenizer tokens = new StringTokenizer(text, " *=");
                    if (tokens.hasMoreTokens()) {
                        String subcommand = "";
                        String command = tokens.nextToken();
                        if (tokens.hasMoreTokens()) {
                            subcommand = tokens.nextToken();
                        }
                        this.parsedMCFLines[this.index] = new MCFLine(command, subcommand);
                        if (this.parsedMCFLines[this.index].getCommand() == 255) {
                            this.syntaxError = true;
                            this.isError = true;
                            this.logError("Invalid keyword = [" + command + "]", (short)-8153);
                        }
                        ++this.index;
                        Trace.trace(TRACE_MASKD, "KeyCommand=[" + command + "].");
                        Trace.trace(TRACE_MASKD, "KeySubcommand=[" + subcommand + "].");
                    }
                } else if (nodeName.equals("designer")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    this.author = text;
                    Trace.trace(TRACE_MASKD, "author=[" + this.author + "].");
                } else if (nodeName.equals("passed-apply-test")) {
                    this.passedApplyTest = true;
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    if (text.toLowerCase().equals("false")) {
                        this.passedApplyTest = false;
                    }
                    Trace.trace(TRACE_MASKD, "passed-apply-test=[" + this.passedApplyTest + "].");
                } else if (nodeName.equals("description")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    this.description = new LocalizableText(text);
                    Trace.trace(TRACE_MASKD, "description=[" + this.description + "].");
                } else if (nodeName.equals("release-date")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    StringTokenizer tokens = new StringTokenizer(text, "/");
                    UserContext userContext = UserContext.getCurrentUserContext();
                    Calendar calendar = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
                    if (tokens.hasMoreTokens()) {
                        String yearStr = tokens.nextToken();
                        if (tokens.hasMoreTokens()) {
                            String monthStr = tokens.nextToken();
                            if (tokens.hasMoreTokens()) {
                                String dayStr = tokens.nextToken();
                                int intYear = Integer.parseInt(yearStr, 10);
                                if (intYear < 100) {
                                    intYear += 2000;
                                }
                                int intMonth = Integer.parseInt(monthStr, 10) - 1;
                                int intDay = Integer.parseInt(dayStr, 10);
                                calendar.clear();
                                calendar.set(intYear, intMonth, intDay);
                                this.creationDate = calendar.getTime();
                            }
                        }
                    }
                    Trace.trace(TRACE_MASKD, "Date=[" + this.creationDate + "].");
                } else if (nodeName.equals("type")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    if ((text = text.toLowerCase()).equals("permanent")) {
                        this.typeOfMCF = 2;
                    } else if (text.equals("temporary")) {
                        this.typeOfMCF = 1;
                    } else if (text.equals("as-required")) {
                        this.typeOfMCF = 3;
                    }
                    Trace.trace(TRACE_MASKF, "type of MCF=[" + this.typeOfMCF + "] " + " (1 is Temporary, 2 is Permanent," + " 3 is As Required)");
                } else if (nodeName.equals("mcf-state-on-SE")) {
                    int byteState;
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    Trace.trace(TRACE_MASKD, "MCFstateInput=[" + text + "].");
                    if (text.equals("...")) {
                        byteState = 32;
                    } else {
                        Integer intState = new Integer(text);
                        byteState = intState.byteValue();
                    }
                    this.automaticallyUpdated = 1 == (byteState & 1);
                    this.isError = 64 == (byteState & 0x40);
                    if (2 == (byteState & 2)) {
                        this.state = 16 == (byteState & 0x10) ? 2 : 4;
                    }
                    if (32 == (byteState & 0x20)) {
                        this.state = 16 == (byteState & 0x10) ? 3 : 1;
                    }
                    Trace.trace(TRACE_MASKD, "MCFstate=[" + this.state + "].");
                }
            }
        }
        catch (HException e) {
            this.isError = true;
            throw e;
        }
        Trace.trace(TRACE_MASKT, "<- traverse()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processKeywords(boolean activating, boolean processingMCL, int linesToProcess) throws HException {
        ShutdownManager shutdownManager;
        BaseTower myBaseTower;
        boolean applyNow;
        block97: {
            int lineNumber;
            Trace.trace(TRACE_MASKT, "-> processKeywords()");
            Trace.trace(TRACE_MASKD, "linesToProcess=" + linesToProcess);
            applyNow = false;
            myBaseTower = BaseTower.getBaseTower();
            UpdateManager manager = UpdateManager.getUpdateManager();
            shutdownManager = ShutdownManager.getShutdownManager();
            try {
                block39: for (lineNumber = 0; lineNumber < linesToProcess; ++lineNumber) {
                    MCFLine thisLine = this.linesOfMCF[lineNumber];
                    String thisFn = thisLine.name;
                    Trace.trace(TRACE_MASKD, "thisLine = [" + thisLine + "]");
                    this.processingFile = thisFn;
                    Trace.trace(TRACE_MASKF, "    thisLine.command = " + thisLine.command);
                    switch (thisLine.command) {
                        case 1: {
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToPatch = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToPatch = [" + fileToPatch + "]");
                            String newFile = this.newFormat ? this.controlFilePrefix + this.streamName + this.getId() + '_' + thisFn : this.controlFilePrefix + this.streamName + thisLine.suffix.charAt(1) + "." + this.getId();
                            Trace.trace(TRACE_MASKD, "newFile = [" + newFile + "]");
                            File stagingArea = new File(this.stagingAreaPath);
                            String[] files = stagingArea.list(new MCFFilter(this));
                            if (files != null) {
                                boolean done = false;
                                for (int i = 0; i < files.length && !done; ++i) {
                                    if (!newFile.equalsIgnoreCase(files[i])) continue;
                                    newFile = files[i];
                                }
                            }
                            String newFileWithPath = this.stagingAreaPath + newFile;
                            Trace.trace(TRACE_MASKD, "id=" + this.getId());
                            Trace.trace(TRACE_MASKD, "newFile=" + newFile);
                            if (activating) {
                                this.copyNewFile(newFileWithPath, fileToPatch, applyNow);
                                PatchedFileList.addFile(fileToPatch);
                                continue block39;
                            }
                            this.backupAndEraseFile(newFileWithPath, fileToPatch, applyNow);
                            continue block39;
                        }
                        case 9: {
                            applyNow = true;
                            continue block39;
                        }
                        case 10: {
                            if (activating) {
                                String acceptECnumber = thisFn.substring(0, 6);
                                UpdateableComponent acceptEC = manager.getComponentByECNumber(acceptECnumber);
                                if (acceptEC == null) {
                                    this.logError("EC stream " + acceptECnumber + " is not on the platform.", (short)-8160);
                                }
                                String acceptListPath = " ";
                                try {
                                    try {
                                        acceptListPath = BaseFileControl.getFilePath(XMCF_ACCEPT_LIST);
                                    }
                                    catch (HException e) {
                                        this.logAndRethrowError("Could not find path of iqzmacpt.lst. " + e, (short)-8155, e);
                                    }
                                    acceptListPath = acceptListPath + XMCF_ACCEPT_LIST;
                                    FileWriter outputStream = new FileWriter(acceptListPath, true);
                                    outputStream.write(thisFn + LINE_SEPARATOR);
                                    outputStream.close();
                                }
                                catch (IOException e) {
                                    this.logError("Error writing to " + acceptListPath + ".", (short)-8191);
                                }
                                continue block39;
                            }
                            File acceptList = new File(XMCF_ACCEPT_LIST);
                            acceptList.delete();
                            continue block39;
                        }
                        case 2: {
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToPatch = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToPatch = [" + fileToPatch + "]");
                            String newFile = this.newFormat ? this.controlFilePrefix + this.streamName + this.getId() + '_' + thisFn : this.controlFilePrefix + this.streamName + thisLine.suffix.charAt(1) + "." + this.getId();
                            Trace.trace(TRACE_MASKD, "newFile = [" + newFile + "]");
                            File stagingArea = new File(this.stagingAreaPath);
                            String[] files = stagingArea.list(new MCFFilter(this));
                            if (files != null) {
                                boolean done = false;
                                for (int i = 0; i < files.length && !done; ++i) {
                                    if (!newFile.equalsIgnoreCase(files[i])) continue;
                                    newFile = files[i];
                                }
                            }
                            String newFileWithPath = this.stagingAreaPath + newFile;
                            if (activating) {
                                this.backupAndEraseFile(newFileWithPath, fileToPatch, applyNow);
                                continue block39;
                            }
                            this.copyNewFile(newFileWithPath, fileToPatch, applyNow);
                            PatchedFileList.addFile(fileToPatch);
                            continue block39;
                        }
                        case 11: {
                            if (!activating) continue block39;
                            String eraseECnumber = thisFn.substring(0, 6);
                            UpdateableComponent eraseEC = manager.getComponentByECNumber(eraseECnumber);
                            if (eraseEC == null) {
                                this.logError("EC stream " + eraseECnumber + " is not on the platform.", (short)-8159);
                            }
                            MCF eraseMCF = null;
                            List allMCLs = eraseEC.getUpdateCollections();
                            String idOfMCFToErase = thisFn.substring(8, 10);
                            Iterator counter = allMCLs.iterator();
                            while (counter.hasNext() && eraseMCF == null) {
                                MCL nextMCL = (MCL)counter.next();
                                List allMCFs = nextMCL.getUpdates();
                                Iterator counterOfMCFs = allMCFs.iterator();
                                while (counterOfMCFs.hasNext() && eraseMCF == null) {
                                    MCF nextMCF = (MCF)counterOfMCFs.next();
                                    if (!idOfMCFToErase.equals(nextMCF.getId())) continue;
                                    eraseMCF = nextMCF;
                                }
                            }
                            if (eraseMCF == null) continue block39;
                            if (eraseMCF.state == 4) {
                                eraseMCF.reject(processingMCL);
                            }
                            eraseMCF.delete();
                            continue block39;
                        }
                        case 4: {
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToExecute = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToExecute = [" + fileToExecute + "]");
                            if (!activating) continue block39;
                            String[] patchCmd = new String[]{"sh", fileToExecute};
                            Process patchProcess = Runtime.getRuntime().exec(patchCmd);
                            int rc = 0;
                            boolean done = false;
                            while (!done) {
                                try {
                                    rc = patchProcess.waitFor();
                                    done = true;
                                }
                                catch (InterruptedException e) {}
                            }
                            if (rc == 0) continue block39;
                            this.logError("AEXEC " + fileToExecute + " failed with return code of " + rc, (short)-8170);
                            continue block39;
                        }
                        case 5: {
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToExecute = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToExecute = [" + fileToExecute + "]");
                            if (activating) continue block39;
                            String[] patchCmd = new String[]{"sh", fileToExecute};
                            Process patchProcess = Runtime.getRuntime().exec(patchCmd);
                            int rc = 0;
                            boolean done = false;
                            while (!done) {
                                try {
                                    rc = patchProcess.waitFor();
                                    done = true;
                                }
                                catch (InterruptedException e) {}
                            }
                            if (rc == 0) continue block39;
                            this.logError("DEXEC " + fileToExecute + " failed with return code of " + rc, (short)-8169);
                            continue block39;
                        }
                        case 6: {
                            Process patchProcess;
                            String[] patchCmd;
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToExecute = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToExecute = [" + fileToExecute + "]");
                            if (!activating) continue block39;
                            if (applyNow) {
                                patchCmd = new String[]{"sh", "rpm", "-u", fileToExecute};
                                patchProcess = Runtime.getRuntime().exec(patchCmd);
                                int rc = 0;
                                boolean done = false;
                                while (!done) {
                                    try {
                                        rc = patchProcess.waitFor();
                                        done = true;
                                    }
                                    catch (InterruptedException e) {}
                                }
                                if (rc == 0) continue block39;
                                this.logError("RPM " + fileToExecute + "failed with return code of " + rc, (short)-8165);
                                continue block39;
                            }
                            FileWriter outputStream = null;
                            outputStream = new FileWriter(this.afterRebootShellFilePath, true);
                            String command = "rpm -u '" + fileToExecute + "'" + LINE_SEPARATOR;
                            outputStream.write(command);
                            Object var27_73 = null;
                            if (null == outputStream) continue block39;
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                this.logError("Error closing reboot shell script " + e2, (short)-8157);
                            }
                            continue block39;
                            {
                                catch (IOException e) {
                                    this.logError("Error queuing execute of " + fileToExecute + " RPM.", (short)-8156);
                                    var27_73 = null;
                                    if (null == outputStream) continue block39;
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException e2) {
                                        this.logError("Error closing reboot shell script " + e2, (short)-8157);
                                    }
                                    continue block39;
                                }
                            }
                            catch (Throwable throwable) {
                                var27_73 = null;
                                if (null != outputStream) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException e2) {
                                        this.logError("Error closing reboot shell script " + e2, (short)-8157);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        case 8: {
                            applyNow = false;
                            continue block39;
                        }
                        case 3: {
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToPatch = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToPatch = [" + fileToPatch + "]");
                            String newFile = this.newFormat ? this.controlFilePrefix + this.streamName + this.getId() + '_' + thisFn : this.controlFilePrefix + this.streamName + thisLine.suffix.charAt(1) + "." + this.getId();
                            Trace.trace(TRACE_MASKD, "newFile = [" + newFile + "]");
                            File stagingArea = new File(this.stagingAreaPath);
                            String[] files = stagingArea.list(new MCFFilter(this));
                            if (files != null) {
                                boolean done = false;
                                for (int i = 0; i < files.length && !done; ++i) {
                                    if (!newFile.equalsIgnoreCase(files[i])) continue;
                                    done = true;
                                    newFile = files[i];
                                }
                            }
                            String newFileWithPath = this.stagingAreaPath + newFile;
                            Trace.trace(TRACE_MASKD, "newFileWithPath=" + newFileWithPath);
                            this.swapFiles(newFileWithPath, fileToPatch, applyNow);
                            PatchedFileList.addFile(fileToPatch);
                            continue block39;
                        }
                        case 12: {
                            String errMsg;
                            String dfcPath = "";
                            if (FILE_SEP != thisFn.charAt(0)) {
                                dfcPath = BaseFileControl.getFilePath(thisFn);
                            }
                            String fileToPatch = dfcPath + thisFn;
                            Trace.trace(TRACE_MASKD, "fileToPatch = [" + fileToPatch + "]");
                            String justName = this.controlFilePrefix + this.streamName + this.id + '_' + thisFn;
                            String mcfFileName = this.stagingAreaPath + justName;
                            String patchFileName = this.patchedStagingAreaPath + justName;
                            File test = new File(patchFileName);
                            if (!test.exists()) {
                                File theTarget;
                                File theSource;
                                int dirEnd;
                                String theDir;
                                PatchFile newDir;
                                String sourceFileName = mcfFileName;
                                if (!this.newFormat) {
                                    String justNameOld = 'H' + this.streamName + this.id + '_' + thisFn;
                                    sourceFileName = this.stagingAreaPath + justNameOld;
                                    File stagingArea = new File(this.stagingAreaPath);
                                    String[] files = stagingArea.list(new MCFFilter(this));
                                    if (files != null) {
                                        for (int i = 0; i < files.length; ++i) {
                                            if (!sourceFileName.equalsIgnoreCase(files[i])) continue;
                                            sourceFileName = files[i];
                                        }
                                    }
                                    files = null;
                                    stagingArea = null;
                                }
                                if (!(newDir = new PatchFile(theDir = patchFileName.substring(0, dirEnd = patchFileName.lastIndexOf(FILE_SEP)))).mkdirs()) {
                                    String errMsg2 = "Error creating directory [" + theDir + "]" + "that we are moving patch " + "file to";
                                    Trace.trace(TRACE_MASKF, "    " + errMsg2);
                                    this.logError(errMsg2, (short)-8136);
                                }
                                if (!(theSource = new File(sourceFileName)).renameTo(theTarget = new File(patchFileName))) {
                                    errMsg = "Error moving the patch file [" + sourceFileName + "] to the mcf/patched " + "directory [" + patchFileName + "].";
                                    Trace.trace(TRACE_MASKF, "    " + errMsg);
                                    this.logError(errMsg, (short)-8139);
                                }
                            }
                            if (!(test = new File(mcfFileName)).exists()) {
                                File tmpDir = new File(this.stagingAreaPath);
                                File temp = File.createTempFile("patchApply", "", tmpDir);
                                String tempFileName = temp.getPath();
                                try {
                                    this.convertHexpatch(patchFileName, fileToPatch, tempFileName);
                                }
                                catch (Exception e) {
                                    temp.delete();
                                    throw e;
                                }
                                File theSource = new File(tempFileName);
                                File theTarget = new File(mcfFileName);
                                if (!theSource.renameTo(theTarget)) {
                                    String errMsg3 = "Error moving the temp file [" + tempFileName + "] to the mcf " + "directory [" + mcfFileName + "].";
                                    Trace.trace(TRACE_MASKF, "    " + errMsg3);
                                    this.logError(errMsg3, (short)-8138);
                                }
                                boolean hadProblem = false;
                                test = new File(patchFileName);
                                if (test.delete()) {
                                    if (!test.createNewFile()) {
                                        hadProblem = true;
                                    }
                                } else {
                                    hadProblem = true;
                                }
                                if (hadProblem) {
                                    errMsg = "Unable to convert patch file [" + patchFileName + "] to 0-length file.";
                                    Trace.trace(TRACE_MASKF, "   " + errMsg);
                                    HException hexc = new HException(errMsg);
                                    FrameworkLog log = new FrameworkLog(logInfo, -8137, hexc);
                                    log.log(FrameworkLogAttributes.INFO_LOG);
                                }
                            }
                            test = null;
                            this.swapFiles(mcfFileName, fileToPatch, applyNow);
                            PatchedFileList.addFile(fileToPatch);
                            continue block39;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.isError) break block97;
                this.isError = true;
                this.lastStatusChangeDate = new Date();
                this.logError("Error processing MCF. " + e, (short)-8164, e);
                if (!processingMCL) {
                    short eventId = 576;
                    String eventName = "MCFDEACTFAIL";
                    if (activating) {
                        eventId = 569;
                        eventName = "MCFACTFAIL";
                    }
                    String[] substText = new String[]{this.controlFileName};
                    FrameworkEventText eventText = new FrameworkEventText(eventId, substText);
                    new SystemEventLog(eventText, eventName).log();
                    new E4EventLog(eventText, eventName).log();
                }
                this.processKeywords(!activating, processingMCL, lineNumber - 1);
                this.updateControlFile();
                HException hexc = new HException(e);
                throw hexc;
            }
        }
        if (!this.isError) {
            LocalizableText applicationMessage;
            LocalizableText applicationName;
            FrameworkEventText eventText;
            String[] substText;
            if (activating) {
                this.automaticallyUpdated = processingMCL;
                if (applyNow) {
                    this.state = 4;
                } else {
                    this.state = 2;
                    this.displayableError = new LocalizableText(this.getDisplayableName() + " will be activated after reboot");
                    this.setLastMessage("MCFARB");
                }
                if (1 == this.typeOfMCF) {
                    short count = myBaseTower.getTemporaryFixesActivated();
                    count = (short)(count + 1);
                    Trace.trace(TRACE_MASKD, count + " temporary fixes are activated");
                    myBaseTower.setTemporaryFixesActivated(count);
                } else if (!processingMCL) {
                    short count = myBaseTower.getPermanentFixesActivated();
                    Trace.trace(TRACE_MASKD, count + " permanent fixes were activated");
                    count = (short)(count + 1);
                    Trace.trace(TRACE_MASKD, count + " permanent fixes are activated");
                    myBaseTower.setPermanentFixesActivated(count);
                }
                if (!processingMCL) {
                    substText = new String[]{this.controlFileName};
                    eventText = new FrameworkEventText(28, substText);
                    new SystemEventLog(eventText, "MCFACT").log();
                    new E4EventLog(eventText, "MCFACT").log();
                } else {
                    applicationName = new LocalizableText("Change management");
                    applicationMessage = new LocalizableText("Rebooting to apply updates");
                    ShutdownRequest request = new ShutdownRequest(applicationName, 2, applicationMessage);
                    request.setDeferred(true);
                    try {
                        Trace.trace(TRACE_MASKD, "Adding a request to shutdown.");
                        shutdownManager.shutdownRequest(request);
                    }
                    catch (ShutdownInProcessException exc) {}
                }
            } else {
                if (applyNow) {
                    this.state = 1;
                } else {
                    this.state = 3;
                    this.displayableError = new LocalizableText(this.getDisplayableName() + "will be deactivated after reboot");
                    this.setLastMessage("MCFDRB");
                }
                if (1 == this.typeOfMCF) {
                    short count = myBaseTower.getTemporaryFixesActivated();
                    count = (short)(count - 1);
                    Trace.trace(TRACE_MASKD, count + " temporary fixes are activated");
                    myBaseTower.setTemporaryFixesActivated(count);
                } else if (!processingMCL) {
                    short count = myBaseTower.getPermanentFixesActivated();
                    Trace.trace(TRACE_MASKD, count + " permanent fixes were activated");
                    count = (short)(count - 1);
                    Trace.trace(TRACE_MASKD, count + " permanent fixes are activated");
                    myBaseTower.setPermanentFixesActivated(count);
                }
                if (!processingMCL) {
                    substText = new String[]{this.controlFileName};
                    eventText = new FrameworkEventText(29, substText);
                    new SystemEventLog(eventText, "MCFDEACT").log();
                    new E4EventLog(eventText, "MCFDEACT").log();
                } else {
                    applicationName = new LocalizableText("Change management");
                    applicationMessage = new LocalizableText("Rebooting to reject updates");
                    ShutdownRequest request = new ShutdownRequest(applicationName, 2, applicationMessage);
                    request.setDeferred(true);
                    try {
                        Trace.trace(TRACE_MASKD, "Adding a request to shutdown.");
                        shutdownManager.shutdownRequest(request);
                    }
                    catch (ShutdownInProcessException exc) {
                        // empty catch block
                    }
                }
            }
            this.lastStatusChangeDate = new Date();
            this.updateControlFile();
        }
        Trace.trace(TRACE_MASKT, "<- processKeywords()");
    }

    private void copyNewFile(String fileName1, String fileName2, boolean applyNow) throws HException {
        Trace.trace(TRACE_MASKT, "-> copyNewFile() - MCF file = [" + fileName1 + "], " + "target file = [" + fileName2 + "], " + "applyNow = " + applyNow);
        PatchFile newDir = new PatchFile(new File(fileName2).getParentFile().getPath());
        Trace.trace(TRACE_MASKD, "   copyNewFile() - newDir = [" + newDir.getPath() + "]");
        if (!newDir.mkdirs()) {
            this.logError("Unable to create parent directory for new file [" + fileName2 + "].", (short)-8140);
        }
        boolean fileExists = false;
        String lastQueuedVersion = this.findQueued(fileName2);
        if (null == lastQueuedVersion) {
            if (new PatchFile(fileName2).exists()) {
                fileExists = true;
            }
        } else if (this.lastQueuedExists) {
            fileExists = true;
        }
        if (fileExists) {
            PatchFile tFile = new PatchFile(fileName2);
            if (tFile.isDirectory()) {
                String errMsg = "File " + fileName2 + " was not expected to exist AND it is a " + "directory!";
                Trace.trace(TRACE_MASKD, "   copyNewFile() - " + errMsg);
                this.logError(errMsg, (short)-8184);
            } else {
                tFile.delete();
                String errMsg = "File " + fileName2 + " was not expected to exist.";
                Trace.trace(TRACE_MASKD, "   copyNewFile() - " + errMsg);
                HException hexc = new HException(errMsg);
                FrameworkLog log = new FrameworkLog(logInfo, -8184, hexc);
                log.log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        if (!applyNow || null != lastQueuedVersion) {
            this.copyDuringReboot(fileName1, fileName2);
        } else {
            try {
                UpdateUtilities.copyFile(fileName1, fileName2);
                PatchFile file1 = new PatchFile(fileName1);
                file1.delete();
            }
            catch (IOException e) {
                this.logError("Error copying " + fileName1 + " to " + fileName2 + ".", (short)-8178);
            }
        }
        Trace.trace(TRACE_MASKT, "<- copyNewFile()");
    }

    private void backupAndEraseFile(String backupFile, String executingFile, boolean applyNow) throws HException {
        Trace.trace(TRACE_MASKT, "-> backupAndEraseFile() - backup file = [" + backupFile + "], " + "target file = [" + executingFile + "], " + "applyNow = " + applyNow);
        String lastVersion = executingFile;
        boolean fileExists = false;
        String lastQueuedVersion = this.findQueued(executingFile);
        if (null == lastQueuedVersion) {
            if (new File(executingFile).exists()) {
                fileExists = true;
            }
        } else if (this.lastQueuedExists) {
            fileExists = true;
            lastVersion = lastQueuedVersion;
        }
        if (!fileExists) {
            String errMsg = "File " + lastVersion + " is expected to exist.";
            this.logError(errMsg, (short)-8176);
        }
        if (!lastVersion.equals(backupFile)) {
            try {
                UpdateUtilities.copyFile(lastVersion, backupFile);
            }
            catch (IOException e) {
                this.logError("Error copying " + executingFile + " to " + backupFile + ".", (short)-8175);
            }
        }
        if (!applyNow || null != lastQueuedVersion) {
            this.copyDuringReboot(executingFile, backupFile);
        } else {
            File file1 = new File(executingFile);
            file1.delete();
        }
        Trace.trace(TRACE_MASKT, "<- backupAndEraseFile()");
    }

    private void swapFiles(String fileName1, String fileName2, boolean applyNow) throws HException {
        PatchFile file2;
        Trace.trace(TRACE_MASKT, "-> swapFiles() - MCF file = [" + fileName1 + "], " + "target file = [" + fileName2 + "], " + "applyNow = " + applyNow);
        String lastVersion = fileName2;
        String lastQueuedVersion = this.findQueued(fileName2);
        if (null != lastQueuedVersion && this.lastQueuedExists) {
            lastVersion = lastQueuedVersion;
        }
        if (!(file2 = new PatchFile(lastVersion)).exists()) {
            this.logError("File " + lastVersion + " is expected to exist.", (short)-8185);
        }
        Trace.trace(TRACE_MASKF, "   swapFiles() - Last Version = [" + lastVersion + "], " + "Last Queued Version = [" + lastQueuedVersion + "]");
        if (!applyNow || null != lastQueuedVersion) {
            String readyToGoFile = fileName1.substring(this.stagingAreaPath.length());
            readyToGoFile = this.tempStagingAreaPath + readyToGoFile;
            if (readyToGoFile.equals(lastVersion)) {
                Trace.trace(TRACE_MASKF, "Special processing to undo work previously done.");
                try {
                    UpdateUtilities.copyFile(lastVersion, fileName1);
                }
                catch (IOException e) {
                    this.logError("Error copying " + lastVersion + " to " + fileName1 + ".", (short)-8147);
                }
                this.undoCopyDuringReboot(readyToGoFile, fileName2);
            } else {
                try {
                    UpdateUtilities.copyFile(fileName1, readyToGoFile);
                }
                catch (IOException e) {
                    this.logError("Error copying " + fileName1 + " to " + readyToGoFile + ".", (short)-8174);
                }
                try {
                    UpdateUtilities.copyFile(lastVersion, fileName1);
                }
                catch (IOException e) {
                    this.logError("Error copying " + lastVersion + " to " + fileName1 + ".", (short)-8181);
                }
                this.copyDuringReboot(readyToGoFile, fileName2);
            }
        } else {
            try {
                UpdateUtilities.copyFile(fileName2, XMCF_TEMP_FILE);
            }
            catch (IOException e) {
                this.logError("Error copying " + fileName1 + " to " + XMCF_TEMP_FILE + ".", (short)-8183);
            }
            try {
                UpdateUtilities.copyFile(fileName1, fileName2);
            }
            catch (IOException e) {
                this.logError("Error copying " + fileName1 + " to " + fileName2 + ".", (short)-8182);
            }
            try {
                UpdateUtilities.copyFile(XMCF_TEMP_FILE, fileName1);
            }
            catch (IOException e) {
                this.logError("Error copying /tmp/mcf.tmp to " + fileName1 + ".", (short)-8180);
            }
            File tempFile = new File(XMCF_TEMP_FILE);
            tempFile.delete();
        }
        Trace.trace(TRACE_MASKT, "<- swapFiles()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyDuringReboot(String sourceFile, String destinationFile) throws HException {
        block33: {
            block32: {
                Trace.trace("XMCFMCFT", "-> copyDuringReboot() - source file = [" + sourceFile + "], " + "target file = [" + destinationFile + "]");
                outputStream = null;
                afterRebootFile = new File(this.afterRebootShellFilePath);
                filePosition = -1;
                fileExists = false;
                reverseString = "";
                fileLength = 0;
                if (afterRebootFile.exists()) {
                    fileExists = true;
                    bufInputFile = null;
                    try {
                        fileLength = (int)afterRebootFile.length();
                        inputFile = new FileInputStream(afterRebootFile);
                        bufInputFile = new BufferedInputStream(inputFile, fileLength);
                        buffer = new byte[fileLength];
                        bytesRead = bufInputFile.read(buffer, 0, fileLength);
                        stringBuffer = new String(buffer, 0, fileLength);
                        reverseString = this.buildMoveCommand(destinationFile, sourceFile);
                        filePosition = stringBuffer.lastIndexOf(reverseString);
                        Trace.trace("XMCFMCFD", "reverseString=[" + reverseString + "], " + "stringBuffer=[" + stringBuffer + "]");
                        Trace.trace("XMCFMCFD", "Search for reverse command yields " + filePosition);
                    }
                    catch (IOException e) {
                        this.logError("Error reading the reboot shell script " + e, (short)-8151);
                        var15_20 = null;
                        if (null != bufInputFile) {
                            try {
                                bufInputFile.close();
                            }
                            catch (IOException e) {
                                this.logError("Error closing reboot shell script " + e, (short)-8150);
                            }
                        }
                        break block32;
                    }
                    var15_19 = null;
                    if (null == bufInputFile) break block32;
                    {
                        catch (Throwable var14_25) {
                            var15_21 = null;
                            if (null == bufInputFile) throw var14_25;
                            ** try [egrp 2[TRYBLOCK] [4 : 303->311)] { 
lbl43:
                            // 1 sources

                            bufInputFile.close();
                            throw var14_25;
lbl45:
                            // 1 sources

                            catch (IOException e) {
                                this.logError("Error closing reboot shell script " + e, (short)-8150);
                            }
                            throw var14_25;
                        }
                        ** try [egrp 2[TRYBLOCK] [4 : 303->311)] { 
lbl49:
                        // 1 sources

                        bufInputFile.close();
lbl51:
                        // 1 sources

                        catch (IOException e) {}
                        this.logError("Error closing reboot shell script " + e, (short)-8150);
                    }
                }
            }
            if (-1 != filePosition) {
                instream = null;
                try {
                    instream = new RandomAccessFile(this.afterRebootShellFilePath, "rw");
                    Trace.trace("XMCFMCFD", "Moving pointer to " + (filePosition + reverseString.length()));
                    instream.seek(filePosition + reverseString.length());
                    bytesToMove = fileLength - (filePosition + reverseString.length());
                    Trace.trace("XMCFMCFD", "Reading " + bytesToMove + " bytes.");
                    buffer = new byte[bytesToMove];
                    instream.readFully(buffer);
                    Trace.trace("XMCFMCFD", "Moving pointer to " + filePosition + ".");
                    instream.seek(filePosition);
                    instream.write(buffer);
                    Trace.trace("XMCFMCFD", "Setting file length to " + (fileLength - reverseString.length()));
                    instream.setLength(fileLength - reverseString.length());
                    Trace.trace("XMCFMCFF", "Removed [" + reverseString + "] from script");
                }
                catch (IOException e) {
                    this.logError("Error attempting to remove a command from the script =" + e, (short)-8149);
                    var18_27 = null;
                    if (null != instream) {
                        try {
                            Trace.trace("XMCFMCFD", "Closing the file.");
                            instream.close();
                        }
                        catch (IOException e) {
                            this.logError("Error on close of control file =" + e, (short)-8148);
                        }
                    }
                    break block33;
                }
                var18_26 = null;
                if (null == instream) break block33;
                {
                    catch (Throwable var17_32) {
                        var18_28 = null;
                        if (null == instream) throw var17_32;
                        ** try [egrp 5[TRYBLOCK] [9 : 654->670)] { 
lbl92:
                        // 1 sources

                        Trace.trace("XMCFMCFD", "Closing the file.");
                        instream.close();
                        throw var17_32;
lbl95:
                        // 1 sources

                        catch (IOException e) {
                            this.logError("Error on close of control file =" + e, (short)-8148);
                        }
                        throw var17_32;
                    }
                    try {}
                    catch (IOException e) {}
                    this.logError("Error on close of control file =" + e, (short)-8148);
                    break block33;
                    Trace.trace("XMCFMCFD", "Closing the file.");
                    instream.close();
                }
            }
            try {
                outputStream = new FileWriter(this.afterRebootShellFilePath, true);
                if (!fileExists) {
                    command = "#!/bin/sh" + MCF.LINE_SEPARATOR;
                    outputStream.write(command);
                    command = "touch /console/data/iqzmlock.run" + MCF.LINE_SEPARATOR;
                    outputStream.write(command);
                    command = "cp " + this.afterRebootShellFilePath + " " + this.afterRebootShellFilePath + ".last" + MCF.LINE_SEPARATOR;
                    outputStream.write(command);
                    command = "rm -f " + this.afterRebootShellFilePath + " 2>>" + this.afterRebootShellFilePath + ".err" + MCF.LINE_SEPARATOR;
                    outputStream.write(command);
                    command = "if [ \"$?\" != \"0\" ] ; then touch " + this.afterRebootShellFilePath + ".err1" + " ; fi" + MCF.LINE_SEPARATOR;
                    outputStream.write(command);
                }
                command = this.buildMoveCommand(sourceFile, destinationFile);
                outputStream.write(command);
                shutdownManager = ShutdownManager.getShutdownManager();
                try {
                    Trace.trace("XMCFMCFD", "Executing addScript");
                    shutdownManager.addScript(this.afterRebootShellFilePath, 1);
                }
                catch (IllegalArgumentException ille) {
                    this.logError("Error adding " + this.afterRebootShellFilePath + " to the reboot manager." + ille, (short)-8152);
                }
                var21_33 = null;
                if (null == outputStream) break block33;
                ** GOTO lbl154
            }
            catch (IOException e) {
                this.logError("Error queuing copy of " + sourceFile + " to " + destinationFile + ".", (short)-8171);
                var21_34 = null;
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        this.logError("Error closing reboot shell script " + e, (short)-8172);
                    }
                }
                break block33;
            }
            {
                catch (Throwable var20_39) {
                    var21_35 = null;
                    if (null == outputStream) throw var20_39;
                    ** try [egrp 9[TRYBLOCK] [15 : 1097->1104)] { 
lbl149:
                    // 1 sources

                    outputStream.close();
                    throw var20_39;
lbl151:
                    // 1 sources

                    catch (IOException e) {
                        this.logError("Error closing reboot shell script " + e, (short)-8172);
                    }
                    throw var20_39;
                }
lbl154:
                // 1 sources

                ** try [egrp 9[TRYBLOCK] [15 : 1097->1104)] { 
lbl155:
                // 1 sources

                outputStream.close();
lbl157:
                // 1 sources

                catch (IOException e) {}
                this.logError("Error closing reboot shell script " + e, (short)-8172);
            }
        }
        Trace.trace("XMCFMCFT", "<- copyDuringReboot()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void undoCopyDuringReboot(String sourceFile, String destinationFile) throws HException {
        block25: {
            block24: {
                Trace.trace("XMCFMCFT", "-> undoCopyDuringReboot() - source file = [" + sourceFile + "], " + "target file = [" + destinationFile + "]");
                outputStream = null;
                afterRebootFile = new File(this.afterRebootShellFilePath);
                filePosition = -1;
                fileExists = false;
                copyString = "";
                fileLength = 0;
                if (afterRebootFile.exists()) {
                    fileExists = true;
                    bufInputFile = null;
                    try {
                        fileLength = (int)afterRebootFile.length();
                        inputFile = new FileInputStream(afterRebootFile);
                        bufInputFile = new BufferedInputStream(inputFile, fileLength);
                        buffer = new byte[fileLength];
                        bytesRead = bufInputFile.read(buffer, 0, fileLength);
                        stringBuffer = new String(buffer, 0, fileLength);
                        copyString = this.buildMoveCommand(sourceFile, destinationFile);
                        Trace.trace("XMCFMCFD", "copyString=[" + copyString + "]");
                        Trace.trace("XMCFMCFD", "stringBuffer=[" + stringBuffer + "]");
                        filePosition = stringBuffer.lastIndexOf(copyString);
                        Trace.trace("XMCFMCFD", "Search for command yields " + filePosition);
                        var15_17 = null;
                        ** if (null == bufInputFile) goto lbl-1000
                    }
                    catch (Throwable var14_23) {
                        var15_19 = null;
                        if (null != bufInputFile) {
                            try {
                                bufInputFile.close();
                            }
                            catch (IOException e) {
                                this.logError("Error closing reboot shell script " + e, (short)-8144);
                            }
                        }
                        throw var14_23;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            bufInputFile.close();
                        }
                        catch (IOException e) {
                            this.logError("Error closing reboot shell script " + e, (short)-8144);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block24;
                        catch (IOException e) {
                            this.logError("Error reading the reboot shell script " + e, (short)-8145);
                            var15_18 = null;
                            if (null != bufInputFile) {
                                try {
                                    bufInputFile.close();
                                }
                                catch (IOException e) {
                                    this.logError("Error closing reboot shell script " + e, (short)-8144);
                                }
                            }
                        }
                    }
                }
            }
            if (-1 != filePosition) {
                instream = null;
                try {
                    instream = new RandomAccessFile(this.afterRebootShellFilePath, "rw");
                    Trace.trace("XMCFMCFD", "Moving pointer to " + (filePosition + copyString.length()));
                    instream.seek(filePosition + copyString.length());
                    bytesToMove = fileLength - (filePosition + copyString.length());
                    Trace.trace("XMCFMCFD", "Reading " + bytesToMove + " bytes.");
                    buffer = new byte[bytesToMove];
                    instream.readFully(buffer);
                    Trace.trace("XMCFMCFD", "Moving pointer to " + filePosition + ".");
                    instream.seek(filePosition);
                    instream.write(buffer);
                    Trace.trace("XMCFMCFD", "Setting file length to " + (fileLength - copyString.length()));
                    instream.setLength(fileLength - copyString.length());
                    Trace.trace("XMCFMCFF", "Removed [" + copyString + "] from script");
                    var18_24 = null;
                    ** if (null == instream) goto lbl-1000
                }
                catch (Throwable var17_30) {
                    var18_26 = null;
                    if (null != instream) {
                        try {
                            Trace.trace("XMCFMCFD", "Closing the file.");
                            instream.close();
                        }
                        catch (IOException e) {
                            this.logError("Error on close of control file =" + e, (short)-8142);
                        }
                    }
                    throw var17_30;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        Trace.trace("XMCFMCFD", "Closing the file.");
                        instream.close();
                    }
                    catch (IOException e) {
                        this.logError("Error on close of control file =" + e, (short)-8142);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                    catch (IOException e) {
                        this.logError("Error attempting to remove a command from the script =" + e, (short)-8143);
                        var18_25 = null;
                        if (null != instream) {
                            try {
                                Trace.trace("XMCFMCFD", "Closing the file.");
                                instream.close();
                            }
                            catch (IOException e) {
                                this.logError("Error on close of control file =" + e, (short)-8142);
                            }
                        }
                    }
                }
            }
        }
        Trace.trace("XMCFMCFT", "<- undoCopyDuringReboot()");
    }

    private String buildMoveCommand(String source, String target) {
        String command = "cp '" + source + "' '" + target + "'" + " 2>>" + this.afterRebootShellFilePath + ".err" + " ; " + "if [ \"$?\" != \"0\" ] ; then " + "touch " + this.afterRebootShellFilePath + ".err2" + " ; fi ; " + "rm '" + source + "'" + " 2>>" + this.afterRebootShellFilePath + ".err" + " ; " + "if [ \"$?\" != \"0\" ] ; then " + "touch " + this.afterRebootShellFilePath + ".err2" + " ; fi" + LINE_SEPARATOR;
        Trace.trace(TRACE_MASKT, "<> makeCommand() - command = [" + command + "]");
        return command;
    }

    private String findQueued(String fileName) throws HException {
        Trace.trace(TRACE_MASKT, "-> findQueued(" + fileName + ")");
        String lastQueuedVersion = null;
        String checkString = null;
        BufferedInputStream bufInputFile = null;
        File afterRebootFile = new File(this.afterRebootShellFilePath);
        if (afterRebootFile.exists()) {
            try {
                int fmPosition;
                int fileLength = (int)afterRebootFile.length();
                FileInputStream inputFile = new FileInputStream(afterRebootFile);
                bufInputFile = new BufferedInputStream(inputFile, fileLength);
                byte[] buffer = new byte[fileLength];
                int bytesRead = bufInputFile.read(buffer, 0, fileLength);
                String stringBuffer = new String(buffer, 0, fileLength);
                String searchString = "'" + fileName + "'";
                int filePosition = stringBuffer.lastIndexOf(searchString);
                if (-1 != filePosition && -1 != (fmPosition = stringBuffer.lastIndexOf("cp ", filePosition))) {
                    String workString = stringBuffer.substring(fmPosition);
                    StringTokenizer tokens = new StringTokenizer(workString, "'");
                    String fmCommand = tokens.nextToken();
                    String sourceParm = tokens.nextToken();
                    String trash = tokens.nextToken();
                    String targetParm = tokens.nextToken();
                    boolean isTargetParm = false;
                    if (targetParm.equals(fileName)) {
                        isTargetParm = true;
                        checkString = targetParm;
                        lastQueuedVersion = sourceParm;
                        this.lastQueuedExists = true;
                    } else {
                        checkString = sourceParm;
                        lastQueuedVersion = targetParm;
                        this.lastQueuedExists = false;
                    }
                    Trace.trace(TRACE_MASKF, "   isTargetParm=" + isTargetParm + ", fmPosition=" + fmPosition + ", fmCommand=" + fmCommand + ", lastQueuedVersion=" + lastQueuedVersion + ", checkString=" + checkString + ", fileName=" + fileName);
                    if (!fileName.equals(checkString)) {
                        ((InputStream)inputFile).close();
                        this.logError("Syntax error in " + this.afterRebootShellFilePath + ".", (short)-8166);
                    }
                }
                bufInputFile.close();
            }
            catch (IOException e) {
                if (bufInputFile != null) {
                    try {
                        bufInputFile.close();
                    }
                    catch (IOException closeException) {
                        this.logError("I/O exception closing startup script " + closeException, (short)-8167);
                    }
                }
                this.logError("I/O exception " + e, (short)-8168);
            }
        }
        Trace.trace(TRACE_MASKT, "<- findQueued() - last version queued is [" + lastQueuedVersion + "]");
        return lastQueuedVersion;
    }

    private void convertHexpatch(String hexpatchFile, String fileToPatch, String newFile) throws FileNotFoundException, IOException, HException {
        Trace.trace(TRACE_MASKT, "-> convertHexpatch() - hexpatchFile = [" + hexpatchFile + "], " + "fileToPatch = [" + fileToPatch + "], " + "newFile = [" + newFile + "]");
        byte[] command = new byte[1];
        byte[] byteOffset = new byte[3];
        byte[] byteLength = new byte[1];
        File hexpatch = new File(hexpatchFile);
        FileInputStream hexpatchInput = new FileInputStream(hexpatchFile);
        BufferedInputStream bufHexpatchInput = new BufferedInputStream(hexpatchInput, 8192);
        File toPatch = new File(fileToPatch);
        FileInputStream toPatchInput = new FileInputStream(fileToPatch);
        BufferedInputStream bufToPatchInput = new BufferedInputStream(toPatchInput, 8192);
        File donePatch = new File(newFile);
        if (donePatch.exists()) {
            donePatch.delete();
        }
        FileOutputStream doneOutput = new FileOutputStream(donePatch);
        BufferedOutputStream bufDoneOutput = new BufferedOutputStream(doneOutput, 8192);
        int bytesRead = bufHexpatchInput.read(command, 0, 1);
        long outputBufferOffset = 0L;
        byte[] buffer = new byte[8192];
        while (bytesRead != -1 && command[0] != 67) {
            switch (command[0]) {
                case 82: {
                    this.readFully(bufHexpatchInput, byteOffset);
                    long offset = BinaryNumber.toUnsignedInt(byteOffset);
                    this.readFully(bufHexpatchInput, byteLength);
                    int lengthToPatch = BinaryNumber.toUnsignedShort(byteLength);
                    Trace.trace(TRACE_MASKD, "Replace " + lengthToPatch + " bytes at offset " + offset + ".");
                    while (offset - outputBufferOffset > 8192L) {
                        bytesRead = bufToPatchInput.read(buffer);
                        bufDoneOutput.write(buffer, 0, bytesRead);
                        outputBufferOffset += 8192L;
                    }
                    this.readFully(bufToPatchInput, buffer, (int)(offset - outputBufferOffset));
                    bufDoneOutput.write(buffer, 0, (int)(offset - outputBufferOffset));
                    this.readFully(bufHexpatchInput, buffer, lengthToPatch);
                    bufDoneOutput.write(buffer, 0, lengthToPatch);
                    this.skipFully(bufToPatchInput, lengthToPatch);
                    outputBufferOffset = offset + (long)lengthToPatch;
                    break;
                }
                case 73: {
                    this.readFully(bufHexpatchInput, byteOffset);
                    long offset = BinaryNumber.toUnsignedInt(byteOffset);
                    this.readFully(bufHexpatchInput, byteLength);
                    int lengthToPatch = BinaryNumber.toUnsignedShort(byteLength);
                    Trace.trace(TRACE_MASKD, "Insert " + lengthToPatch + " bytes at offset " + offset + ".");
                    while (offset - outputBufferOffset > 8192L) {
                        bytesRead = bufToPatchInput.read(buffer);
                        bufDoneOutput.write(buffer, 0, bytesRead);
                        outputBufferOffset += 8192L;
                    }
                    this.readFully(bufToPatchInput, buffer, (int)(offset - outputBufferOffset));
                    bufDoneOutput.write(buffer, 0, (int)(offset - outputBufferOffset));
                    this.readFully(bufHexpatchInput, buffer, lengthToPatch);
                    bufDoneOutput.write(buffer, 0, lengthToPatch);
                    outputBufferOffset = offset + (long)lengthToPatch;
                    break;
                }
                case 68: {
                    this.readFully(bufHexpatchInput, byteOffset);
                    long offset = BinaryNumber.toUnsignedInt(byteOffset);
                    this.readFully(bufHexpatchInput, byteLength);
                    int lengthToPatch = BinaryNumber.toUnsignedShort(byteLength);
                    Trace.trace(TRACE_MASKD, "Delete " + lengthToPatch + " bytes at offset " + offset + ".");
                    while (offset - outputBufferOffset > 8192L) {
                        bytesRead = bufToPatchInput.read(buffer);
                        bufDoneOutput.write(buffer, 0, bytesRead);
                        outputBufferOffset += 8192L;
                    }
                    this.readFully(bufToPatchInput, buffer, (int)(offset - outputBufferOffset));
                    bufDoneOutput.write(buffer, 0, (int)(offset - outputBufferOffset));
                    this.skipFully(bufToPatchInput, lengthToPatch);
                    outputBufferOffset = offset;
                    break;
                }
                default: {
                    this.logError("Invalid command " + command[0] + " in hexpatch.", (short)-8177);
                }
            }
            bytesRead = bufHexpatchInput.read(command, 0, 1);
        }
        bytesRead = bufToPatchInput.read(buffer);
        while (bytesRead != -1) {
            bufDoneOutput.write(buffer, 0, bytesRead);
            bytesRead = bufToPatchInput.read(buffer);
        }
        bufToPatchInput.close();
        bufDoneOutput.close();
        byte[] bytesOfChecksum = new byte[2];
        int calculatedChecksum = 0;
        int shiftAmount = 0;
        if (command[0] != 67) {
            this.logError("No checksum found in hexpatch.", (short)-8161);
        }
        this.readFully(bufHexpatchInput, bytesOfChecksum);
        int fileChecksum = BinaryNumber.toUnsignedShort(bytesOfChecksum);
        bufHexpatchInput.close();
        byte[] checksumBuffer = new byte[1];
        FileInputStream doneInput = new FileInputStream(donePatch);
        BufferedInputStream bufDoneInput = new BufferedInputStream(doneInput, 1);
        while ((bytesRead = bufDoneInput.read(checksumBuffer)) != -1) {
            int remainder;
            int quotient;
            if (checksumBuffer[0] == 0) continue;
            int valueOfChar = BinaryNumber.toUnsignedShort(checksumBuffer);
            if (0 != ((calculatedChecksum += valueOfChar) & 0xFFFF0000)) {
                quotient = calculatedChecksum >>> 16;
                remainder = calculatedChecksum & 0xFFFF;
                calculatedChecksum = quotient + remainder & 0xFFFF;
            }
            if (shiftAmount < 1) {
                shiftAmount = 13;
            }
            if (0 == ((calculatedChecksum <<= --shiftAmount) & 0xFFFF0000)) continue;
            quotient = calculatedChecksum >>> 16;
            remainder = calculatedChecksum & 0xFFFF;
            calculatedChecksum = quotient + remainder & 0xFFFF;
        }
        bufDoneInput.close();
        if (calculatedChecksum != fileChecksum) {
            String msg = "Calculated checksum " + calculatedChecksum + " does not match checksum in file " + fileChecksum + ". File being processed is [" + fileToPatch + "].";
            this.processingFile = fileToPatch;
            this.logError(msg, (short)-8186);
        }
        Trace.trace(TRACE_MASKT, "<- convertHexpatch()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateControlFile() throws HException {
        block29: {
            Trace.trace("XMCFMCFT", "-> updateControlFile()");
            instream = null;
            controlFile = null;
            try {
                block28: {
                    controlFile = this.stagingAreaPath + this.controlFileName;
                    Trace.trace("XMCFMCFF", "File " + controlFile + " is being written with status updates.");
                    Trace.trace("XMCFMCFD", "state=[" + this.state + "]");
                    if (!this.newFormat) {
                        instream = new RandomAccessFile(controlFile, "rw");
                        bytesSkipped = instream.skipBytes(14);
                        statusBits = 0;
                        if (this.state == 4) {
                            statusBits = 2;
                        }
                        if (this.state == 2) {
                            statusBits = 18;
                        }
                        if (this.state == 1) {
                            statusBits = 32;
                        }
                        if (this.state == 3) {
                            statusBits = 48;
                        }
                        if (this.automaticallyUpdated) {
                            statusBits |= 1;
                        }
                        if (this.isError) {
                            statusBits |= 64;
                        }
                        Trace.trace("XMCFMCFD", "statusBits=" + statusBits);
                        instream.write(statusBits);
                        break block28;
                    }
                    parser = new MCFFileParser(controlFile);
                    document = parser.getDocument();
                    stateNodes = document.getElementsByTagName("mcf-state-on-SE");
                    if (stateNodes.getLength() == 0) break block28;
                    statusBits = 0;
                    if (this.state == 4) {
                        statusBits = 2;
                    }
                    if (this.state == 2) {
                        statusBits = 18;
                    }
                    if (this.state == 1) {
                        statusBits = 32;
                    }
                    if (this.state == 3) {
                        statusBits = 48;
                    }
                    if (this.automaticallyUpdated) {
                        statusBits |= 1;
                    }
                    if (this.isError) {
                        statusBits |= 64;
                    }
                    statusString = "";
                    statusString = String.valueOf(statusBits);
                    stateNode = stateNodes.item(0);
                    children = stateNode.getChildNodes();
                    for (i = 0; i < children.getLength(); ++i) {
                        removedChild = stateNode.removeChild(children.item(i));
                    }
                    newText = document.createTextNode(statusString);
                    newNode = stateNode.appendChild(newText);
                    file = new File(controlFile);
                    outputStream = new FileOutputStream(file);
                    outputFormat = new OutputFormat(document, null, true);
                    outputFormat.setPreserveSpace(true);
                    serializer = new XMLSerializer((OutputStream)outputStream, outputFormat);
                    serializer.serialize(document);
                    fileStats = new File(controlFile);
                    lastModifiedDate = fileStats.lastModified();
                    this.lastStatusChangeDate = new Date(lastModifiedDate);
                    Trace.trace("XMCFMCFD", "this.lastStatusChangeDate=[" + this.lastStatusChangeDate + "].");
                }
                var23_24 = null;
                ** if (null == instream) goto lbl-1000
            }
            catch (Throwable var22_40) {
                var23_27 = null;
                if (null != instream) {
                    try {
                        instream.close();
                        fileStats = new File(controlFile);
                        lastModifiedDate = fileStats.lastModified();
                        this.lastStatusChangeDate = new Date(lastModifiedDate);
                    }
                    catch (IOException e) {
                        this.isError = true;
                        this.logError("Error on close of control file =" + e, (short)-8187);
                    }
                }
                throw var22_40;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    instream.close();
                    fileStats = new File(controlFile);
                    lastModifiedDate = fileStats.lastModified();
                    this.lastStatusChangeDate = new Date(lastModifiedDate);
                }
                catch (IOException e) {
                    this.isError = true;
                    this.logError("Error on close of control file =" + e, (short)-8187);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block29;
                catch (IOException e) {
                    this.isError = true;
                    this.logError("IO error =" + e, (short)-8189);
                    var23_25 = null;
                    if (null != instream) {
                        try {
                            instream.close();
                            fileStats = new File(controlFile);
                            lastModifiedDate = fileStats.lastModified();
                            this.lastStatusChangeDate = new Date(lastModifiedDate);
                        }
                        catch (IOException e) {
                            this.isError = true;
                            this.logError("Error on close of control file =" + e, (short)-8187);
                        }
                    }
                    break block29;
                }
                catch (Exception e) {
                    this.logError("error in updatecontrolfile", (short)-8189);
                    var23_26 = null;
                    if (null != instream) {
                        try {
                            instream.close();
                            fileStats = new File(controlFile);
                            lastModifiedDate = fileStats.lastModified();
                            this.lastStatusChangeDate = new Date(lastModifiedDate);
                        }
                        catch (IOException e) {
                            this.isError = true;
                            this.logError("Error on close of control file =" + e, (short)-8187);
                        }
                    }
                }
            }
        }
        Trace.trace("XMCFMCFT", "<- updateControlFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackMcf(String mcfFileName) throws HException {
        block7: {
            Trace.trace(TRACE_MASKT, "-> MCF.unpackMcf()");
            String stagingArea = BaseFileControl.getFilePath(STAGING_AREA_FILE);
            String unzipCmd = "unzip -o " + stagingArea + mcfFileName + " -d " + stagingArea;
            Trace.trace(TRACE_MASKF, "   MCF.unpackMcf() - processing file [" + mcfFileName + "]" + " - staging area is [" + stagingArea + "]" + " - UNZIP command is [" + unzipCmd + "]");
            try {
                IssueCmd cmd = new IssueCmd();
                int rc = cmd.execute(unzipCmd);
                Trace.trace(TRACE_MASKF, "UNZIP [" + unzipCmd + "] completed " + "with a return code of " + rc + "\n" + "Command output was:\n" + cmd.getErrorOutput());
                if (rc > 1) {
                    new FrameworkLog(logInfo, -8134).log(FrameworkLogAttributes.INFO_LOG);
                    File file = new File(stagingArea);
                    String[] files = file.list(new NewMCFFilter(mcfFileName));
                    if (null == files) {
                        files = new String[]{};
                    }
                    for (int i = 0; i < files.length; ++i) {
                        File fileToDelete = new File(files[i]);
                        if (fileToDelete.isDirectory()) {
                            Trace.trace(TRACE_MASKF, "The directory tree" + fileToDelete.getPath() + " is being deleted.");
                            IssueCmd delCmd = new IssueCmd();
                            int delRc = delCmd.execute("rm -r " + fileToDelete.getPath());
                            if (0 == delRc) continue;
                            Trace.trace(TRACE_MASKF, "Error " + delRc + " deleting the " + fileToDelete.getPath() + " directory tree.");
                            Trace.trace(TRACE_MASKF, "Error messages were: \n" + delCmd.getErrorOutput());
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "The file " + fileToDelete.getPath() + " is being deleted.");
                        fileToDelete.delete();
                    }
                }
                Object var12_11 = null;
                File mcfZipFile = new File(stagingArea + mcfFileName);
                if (mcfZipFile.delete()) break block7;
                new FrameworkLog(logInfo, -8135).log(FrameworkLogAttributes.INFO_LOG);
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                File mcfZipFile = new File(stagingArea + mcfFileName);
                if (!mcfZipFile.delete()) {
                    new FrameworkLog(logInfo, -8135).log(FrameworkLogAttributes.INFO_LOG);
                }
                throw throwable;
            }
            {
            }
        }
        Trace.trace(TRACE_MASKT, "<- MCF.unpackMcf()");
    }

    protected void readFully(BufferedInputStream instream, byte[] buffer) throws IOException {
        this.readFully(instream, buffer, buffer.length);
    }

    protected void readFully(BufferedInputStream instream, byte[] buffer, int numberOfBytes) throws IOException {
        int allBytesRead;
        int bytesRead;
        Trace.trace(TRACE_MASKD, "-> readFully()");
        for (allBytesRead = 0; allBytesRead < numberOfBytes; allBytesRead += bytesRead) {
            bytesRead = instream.read(buffer, allBytesRead, numberOfBytes - allBytesRead);
            Trace.trace(TRACE_MASKD, "<- read() read " + bytesRead + " bytes.");
        }
        Trace.trace(TRACE_MASKD, "<- readFully() read " + allBytesRead + " bytes.");
    }

    protected void skipFully(BufferedInputStream instream, int numberOfBytes) throws IOException {
        Trace.trace(TRACE_MASKD, "-> skipFully()");
        long bytesToSkip = numberOfBytes;
        long bytesSkipped = 0L;
        for (long allBytesSkipped = 0L; allBytesSkipped < (long)numberOfBytes; allBytesSkipped += bytesSkipped) {
            bytesSkipped = instream.skip(bytesToSkip - allBytesSkipped);
            Trace.trace(TRACE_MASKD, "<- skipFully() skipped " + bytesSkipped + " bytes.");
        }
        Trace.trace(TRACE_MASKD, "<- skipFully() skipped " + bytesSkipped + " bytes.");
    }

    protected void logError(String errorString, short errorId) throws HException {
        Trace.trace(TRACE_MASKD, "-> logError()");
        String mclInfo = "[none]";
        if (null != this.collection) {
            mclInfo = this.collection.getUpdateableComponent().getDisplayableId() + "." + this.collection.getDisplayableId();
        }
        String mcfInfo = this.getDisplayableName();
        String newErrorString = "Processing MCF " + mcfInfo + " from MCL " + mclInfo + ": " + errorString;
        Trace.trace(TRACE_MASKF, newErrorString);
        HException hexc = new HException(newErrorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.displayableError = new LocalizableText(newErrorString);
        this.setLastMessage(errorId);
        throw hexc;
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.displayableError = new LocalizableText(errorString);
        this.setLastMessage(errorId);
        Trace.trace(TRACE_MASKD, "<- logError()");
    }

    private String[] getListOfFiles() {
        String[] files3;
        String[] files2;
        Trace.trace(TRACE_MASKD, "-> getListOfFiles()");
        File file = new File(this.stagingAreaPath);
        String[] files1 = file.list(new MCFFilter(this));
        if (null == files1) {
            files1 = new String[]{};
        }
        if (null == (files2 = file.list(new NewMCFFilter(this)))) {
            files2 = new String[]{};
        }
        if (null == (files3 = (file = new File(this.patchedStagingAreaPath)).list(new NewMCFFilter(this)))) {
            files3 = new String[]{};
        }
        String[] files = new String[files1.length + files2.length + files3.length];
        int outputArrayIndex = 0;
        int i = 0;
        while (i < files1.length) {
            files[outputArrayIndex] = this.stagingAreaPath + files1[i];
            ++i;
            ++outputArrayIndex;
        }
        i = 0;
        while (i < files2.length) {
            files[outputArrayIndex] = this.stagingAreaPath + files2[i];
            ++i;
            ++outputArrayIndex;
        }
        i = 0;
        while (i < files3.length) {
            files[outputArrayIndex] = this.patchedStagingAreaPath + files3[i];
            ++i;
            ++outputArrayIndex;
        }
        Trace.trace(TRACE_MASKD, "<- getListOfFiles()");
        files1 = null;
        files2 = null;
        files3 = null;
        return files;
    }

    protected void logAndRethrowError(String errorString, short errorId, Exception exc) throws HException {
        HException hexc = new HException(exc);
        this.logError(errorString, errorId, hexc);
        throw hexc;
    }

    protected void setLastMessage(short errorId) {
        String key;
        Trace.trace(TRACE_MASKD, "-> setLastMessage()");
        Object[] parms = new String[]{this.processingFile, this.controlFileName};
        if (errorId == -8186) {
            key = "MCFHPATCH";
        } else if (errorId == -8163 || errorId == -8192) {
            key = "MCFSYNTAX";
            parms[0] = String.valueOf(this.syntaxErrorLine);
        } else {
            key = "MCFPATCH";
        }
        MessageText message = new MessageText(this.bundleName, key, parms);
        super.setLastMessage(message);
        Trace.trace(TRACE_MASKD, "<- setLastMessage()");
    }

    public static int determineMCFType(String controlFileName) throws HException {
        Trace.trace(TRACE_MASKD, "-> determineMCFType()");
        int mcfType = 2;
        switch (controlFileName.charAt(0)) {
            case 'A': 
            case 'a': {
                mcfType = 3;
                break;
            }
            case 'M': 
            case 'T': 
            case 'm': 
            case 't': {
                mcfType = 1;
                break;
            }
            case 'R': 
            case 'r': {
                mcfType = 2;
                break;
            }
            default: {
                String msg = "Control file does not start with an expected character";
                Trace.trace(TRACE_MASKD, "   determineMCFType() - " + msg);
                throw new HException(msg);
            }
        }
        Trace.trace(TRACE_MASKD, "<- determineMCFType() - type is " + mcfType + " (1 is Temporary, 2 is Permanent," + " 3 is As Required)");
        return mcfType;
    }

    protected void setLastMessage(String key) {
        Trace.trace(TRACE_MASKD, "-> setLastMessage()");
        Object[] parms = new String[]{this.controlFileName};
        MessageText message = new MessageText(this.bundleName, key, parms);
        Trace.trace(TRACE_MASKD, "this.bundleName=" + this.bundleName);
        Trace.trace(TRACE_MASKD, "key=" + key);
        Trace.trace(TRACE_MASKD, "parms[0]=" + (String)parms[0]);
        Trace.trace(TRACE_MASKD, "messageText=" + message.getMsgText());
        super.setLastMessage(message);
        Trace.trace(TRACE_MASKD, "<- setLastMessage()");
    }
}

